unit Unit1;

//         ( R, G, B ),
//         TColor.

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    ScrollBarRed: TScrollBar;
    ScrollBarGreen: TScrollBar;
    ScrollBarBlue: TScrollBar;
    LabelRed: TLabel;
    LabelGreen: TLabel;
    LabelBlue: TLabel;
    Shape2: TShape;
    Label1: TLabel;
    Label2: TLabel;
    LabelMRed: TLabel;
    LabelMGrren: TLabel;
    LabelMBlue: TLabel;
    LabelMSysColor: TLabel;
    ComboBox1: TComboBox;
    Label3: TLabel;
    Image1: TImage;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    procedure ScrollBarRedScroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure ScrollBarGreenScroll(Sender: TObject;
      ScrollCode: TScrollCode; var ScrollPos: Integer);
    procedure ScrollBarBlueScroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure Shape2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ComboBox1Click(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    procedure ShowPosScrollBars();
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

//     TColor
type TSRGB = record
  R : byte;    //   
  G : byte;    //   
  B : byte;    //   
  W : byte;    //  
end;

//   ScrollBars,  
procedure TForm1.ShowPosScrollBars();
begin
     LabelRed.Caption   := 'R : ' + IntToStr(ScrollBarRed.Position);
     LabelGreen.Caption := 'G : ' + IntToStr(ScrollBarGreen.Position);
     LabelBlue.Caption  := 'B : ' + IntToStr(ScrollBarBlue.Position);
end;

//    
procedure TForm1.ScrollBarRedScroll(Sender: TObject;
  ScrollCode: TScrollCode; var ScrollPos: Integer);
var CBuf : TColor;
begin
  ShowPosScrollBars();
  //  
  CBuf := RGB (ScrollBarRed.Position,
               ScrollBarGreen.Position,
               ScrollBarBlue.Position);
  Image1.Canvas.Brush.Color := CBuf;
  Image1.Canvas.Brush.Style := bsSolid;
  Image1.Canvas.Rectangle(0,0,Image1.Width, Image1.Height);
  //  
  Shape2.Brush.Color := RGB (255-ScrollBarRed.Position,
                             255-ScrollBarGreen.Position,
                             255-ScrollBarBlue.Position);
end;

//    
procedure TForm1.ScrollBarGreenScroll(Sender: TObject;
  ScrollCode: TScrollCode; var ScrollPos: Integer);
var CBuf : TColor;
begin
  ShowPosScrollBars();
  //  
  CBuf := RGB (ScrollBarRed.Position,
               ScrollBarGreen.Position,
               ScrollBarBlue.Position);
  Image1.Canvas.Brush.Color := CBuf;
  Image1.Canvas.Brush.Style := bsSolid;
  Image1.Canvas.Rectangle(0,0,Image1.Width, Image1.Height);
  //  
  Shape2.Brush.Color := RGB (255-ScrollBarRed.Position,
                             255-ScrollBarGreen.Position,
                             255-ScrollBarBlue.Position);
end;

//    
procedure TForm1.ScrollBarBlueScroll(Sender: TObject;
  ScrollCode: TScrollCode; var ScrollPos: Integer);
var CBuf : TColor;
begin
  ShowPosScrollBars();
  //  
  CBuf := RGB (ScrollBarRed.Position,
               ScrollBarGreen.Position,
               ScrollBarBlue.Position);
  Image1.Canvas.Brush.Color := CBuf;
  Image1.Canvas.Brush.Style := bsSolid;
  Image1.Canvas.Rectangle(0,0,Image1.Width, Image1.Height);
  //  
  Shape2.Brush.Color := RGB (255-ScrollBarRed.Position,
                             255-ScrollBarGreen.Position,
                             255-ScrollBarBlue.Position);
end;

//   Image1
procedure TForm1.Image1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var PtC  : ^TSRGB;
    CBuf : TColor;
begin
   CBuf := Image1.Canvas.Pixels[X, Y];
   PtC := Addr(CBuf);
   LabelMRed.Caption      := 'R : ' + IntToStr(PtC^.R);
   LabelMGrren.Caption    := 'G : ' + IntToStr(PtC^.G);
   LabelMBlue.Caption     := 'B : ' + IntToStr(PtC^.B);
   LabelMSysColor.Caption := 'W : ' + IntToStr(PtC^.W);
end;

//   Shape2
procedure TForm1.Shape2MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var PtC  : ^TSRGB;
    CBuf : TColor;
begin
   CBuf := Shape2.Brush.Color;
   PtC := Addr(CBuf);
   LabelMRed.Caption      := 'R : ' + IntToStr(PtC^.R);
   LabelMGrren.Caption    := 'G : ' + IntToStr(PtC^.G);
   LabelMBlue.Caption     := 'B : ' + IntToStr(PtC^.B);
   LabelMSysColor.Caption := 'W : ' + IntToStr(PtC^.W);
end;

//      Windows
procedure TForm1.ComboBox1Click(Sender: TObject);
var PtC  : ^TSRGB;
    CBuf : TColor;
begin
  case ComboBox1.ItemIndex of
   0:  CBuf := clDefault;
   1:  CBuf := clScrollBar;
   2:  CBuf := clBackground;
   3:  CBuf := clActiveCaption;
   4:  CBuf := clInactiveCaption;
   5:  CBuf := clMenu;
   6:  CBuf := clWindow;
   7:  CBuf := clWindowFrame;
   8:  CBuf := clMenuText;
   9:  CBuf := clWindowText;
  10:  CBuf := clCaptionText;
  11:  CBuf := clActiveBorder;
  12:  CBuf := clInactiveBorder;
  13:  CBuf := clAppWorkSpace;
  14:  CBuf := clHighlight;
  15:  CBuf := clHighlightText;
  16:  CBuf := clBtnFace;
  17:  CBuf := clBtnShadow;
  18:  CBuf := clGrayText;
  19:  CBuf := clBtnText;
  20:  CBuf := clInactiveCaptionText;
  21:  CBuf := clBtnHighlight;
  22:  CBuf := cl3DDkShadow;
  23:  CBuf := cl3DLight;
  24:  CBuf := clInfoText;
  25:  CBuf := clInfoBk;
  26:  CBuf := clGradientActiveCaption;
  27:  CBuf := clGradientInactiveCaption;
  end;
  if ComboBox1.ItemIndex >=0
  then begin
     //      
     PtC := Addr(CBuf);
     LabelMRed.Caption   :=    'N : ' + IntToStr(PtC^.R);
     LabelMGrren.Caption :=    '- : ' + IntToStr(PtC^.G);
     LabelMBlue.Caption  :=    '- : ' + IntToStr(PtC^.B);
     LabelMSysColor.Caption := 'W : ' + IntToStr(PtC^.W);
     //  
     Image1.Canvas.Brush.Color := CBuf;
     Image1.Canvas.Brush.Style := bsSolid;
     Image1.Canvas.Rectangle(0,0,Image1.Width, Image1.Height);
     //      RGB - 
     CBuf := Image1.Canvas.Pixels[Image1.Width div 2, Image1.Height div 2];
     ScrollBarRed.Position   := PtC^.R;
     ScrollBarGreen.Position := PtC^.G;
     ScrollBarBlue.Position  := PtC^.B;
     ShowPosScrollBars();
     //  
     Shape2.Brush.Color := RGB (255-ScrollBarRed.Position,
                                255-ScrollBarGreen.Position,
                                255-ScrollBarBlue.Position);
  end;
end;

//  
procedure TForm1.FormActivate(Sender: TObject);
var CBuf : TColor;
begin
  ShowPosScrollBars();
  CBuf := RGB (ScrollBarRed.Position,
               ScrollBarGreen.Position,
               ScrollBarBlue.Position);
  Image1.Canvas.Brush.Color := CBuf;
  Image1.Canvas.Brush.Style := bsSolid;
  Image1.Canvas.Rectangle(0,0,Image1.Width, Image1.Height);
  Shape2.Brush.Color := RGB (255-ScrollBarRed.Position,
                             255-ScrollBarGreen.Position,
                             255-ScrollBarBlue.Position);
end;

end.
